/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	DiametricDimension.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CDrawing.h"
#include "CApplication.h"


HRESULT DiametricDimension(IDesign *pDesign, IDrawingDocument *pDrawingDoc, IGraphic *pGraph1, IRadialDimLine **diametricdim) 
{
	//	Creates a Diametric Dimension
	START_METHOD("DiametricDimension")

	HRESULT status = CONV_SUCCESS;

	CHECK_VAR_STATUS(pDrawingDoc)

	IDrawingDocument *activeDoc = NULL;

	activeDoc = CAST(IDrawingDocument, pDrawingDoc);
	
	IGraphicDocument *activeGraphicDoc = CAST(IGraphicDocument, activeDoc);

	IDrawingDocOthers *doc1 = CAST(IDrawingDocOthers, pDrawingDoc);

	IDrawing *localDraw= NULL;
	status = activeDoc->GetDrawing(&localDraw);
	CHECK_RETURN_STATUS(status)	
	
	// get the design detail

	IDesignDetail *pDetail = NULL;
	status = localDraw->GetDetail(pDesign, FALSE, &pDetail);
	CHECK_RETURN_STATUS(status)	
	
	// get the paper geometry
	IGeometry *localGeom1 = NULL;
	status = activeDoc->GetPaperGeometry(pGraph1, &localGeom1);
	CHECK_RETURN_STATUS(status)	
	
	IGeometry *pOriginal = NULL;
	status = localGeom1->GetOriginal(&pOriginal);
	CHECK_RETURN_STATUS(status)	
	
	IDesignInstance *pView1 = NULL;
	status = localGeom1->GetInstance(&pView1);
	CHECK_RETURN_STATUS(status)	
	
	// create dimension
	IDimension *pDimension = NULL;

	status = (GetCLASS(Dimension))->CreateDimension(pDetail, 3, pOriginal, &pDimension);
	CHECK_RETURN_STATUS(status)	
	
	IVector *pPosition= NULL;
	status = (GetCLASS(Vector))->CreateVector(0.001, 0.001, 0, &pPosition);
	CHECK_RETURN_STATUS(status)	
	
	// create radial dimension line

	IRadialDimLine *pDiametricDim = NULL;
	status = (GetCLASS(RadialDimLine))->CreateRadialDimLine(pPosition, pDimension, CAST(IHiddenLine, pView1),&pDiametricDim);
	CHECK_RETURN_STATUS(status)	
	
	IDimTol *pTolerance = NULL;
	status = (GetCLASS(DimTol))->CreateDimTol(pDetail, pDimension, &pTolerance);
	CHECK_RETURN_STATUS(status)	

	IDimensionCallout *pCallout = NULL;
	
	status = (GetCLASS(DimensionCallout))->CreateDimensionCallout(pTolerance, &pCallout);
	CHECK_RETURN_STATUS(status)	

	IDimLineText *pText = NULL;
	status = (GetCLASS(DimLineText))->CreateDimLineText(CAST(IDimLine, pDiametricDim), CAST(ICallout, pCallout), pPosition, 0.0035,&pText);
	CHECK_RETURN_STATUS(status)	
	
	ICalloutGroup *localCalloutGroup = CAST(ICalloutGroup, pText);
	
	// set the control point
	status = localCalloutGroup->SetControlPoint(1,pPosition);
	CHECK_RETURN_STATUS(status)	
	
	// Get the active sheet in current drawing
	ISheet *pSheet = NULL;
	status = pDrawingDoc->GetActiveSheet(&pSheet);
	CHECK_RETURN_STATUS(status)

	status = pSheet->AddDimLine(CAST(IDimLine, pDiametricDim));
	CHECK_RETURN_STATUS(status)
	
	// Add center line
	// To be done
	
	*diametricdim = pDiametricDim;
	
	END_METHOD("DiametricDimension")
}
